local skipToTitleMenu = false

Branch.AfterInit = function()
	if GAMESTATE:GetCurrentGame():GetName() == "lights" or skipToTitleMenu then
		return Branch.TitleMenu()
	end
	
	return "ScreenLogo"
end

Branch.AfterSelectProfile = function()
	-- todo: determine whether or not ProfileLoad is needed at all under any circumstances.
	-- In _fallback, this screen's only pulled up after style select, which isn't always (if ever) accessed... Why?
	return "ScreenProfileLoad"
end

Branch.InformationOrSelectMusic = function()
	return PREFSMAN:GetPreference("ShowInstructions") and "ScreenGameInformation" or (GAMESTATE:IsCourseMode() and "ScreenSelectCourse" or "ScreenSelectMusic")
end

local skipModeSelect = true
Branch.PlayModeOrSelectMusic = function()
	-- Are we skipping SelectPlayMode?
	if skipModeSelect then
		-- gamecommand? really?... anyway, patch up the setup skipped from skipping SelectPlayMode.
		-- This might be superfluous but I'd like to avoid potental errors...
		GAMESTATE:ApplyGameCommand("applydefaultoptions;playmode,regular;difficulty,beginner;setenv,sMode,Normal;screen,ScreenSelectMusic")
		return Branch.InformationOrSelectMusic()
	end
	
	return "ScreenSelectPlayMode"
end

Branch.AfterProfileLoad = function()
	-- Are we skipping SelectStyle? (the answer: probably lol)
	if not UsingAutoSetStyle() or IsNetConnected() then return "ScreenSelectStyle" end
	return Branch.PlayModeOrSelectMusic() 
end

Branch.AfterSelectStyle = function()
	if IsNetConnected() then
		ReportStyle()
		GAMESTATE:ApplyGameCommand("playmode,regular")
		return IsNetSMOnline() and SMOnlineScreen() or "ScreenNetRoom"
	end
	return Branch.PlayModeOrSelectMusic()

	--return CHARMAN:GetAllCharacters() ~= nil and "ScreenSelectCharacter" or "ScreenGameInformation"
end

-- todo: what
Branch.AfterEvaluation = function()
	if GAMESTATE:IsCourseMode() then
		return "ScreenProfileSave"
	else
		local maxStages = PREFSMAN:GetPreference("SongsPerPlay")
		local stagesLeft = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer()
		local allFailed = STATSMAN:GetCurStageStats():AllFailed()
		local song = GAMESTATE:GetCurrentSong()

		if GAMESTATE:IsEventMode() or stagesLeft >= 1 then
			return "ScreenProfileSave"
		elseif song:IsLong() and maxStages <= 2 and stagesLeft < 1 and allFailed then
			return "ScreenProfileSaveSummary"
		elseif song:IsMarathon() and maxStages <= 3 and stagesLeft < 1 and allFailed then
			return "ScreenProfileSaveSummary"
		elseif maxStages >= 2 and stagesLeft < 1 and allFailed then
			return "ScreenProfileSaveSummary"
		elseif allFailed then
			return "ScreenProfileSaveSummary"
		else
			return "ScreenProfileSave"
		end
	end
end

Branch.OptionsEdit = function()
	if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
		return "ScreenHowToInstallSongs"
	end
	return "ScreenEditMenu"
end

local skipHowToPlay = true
Branch.AfterAttractLogo = function()
	return skipHowToPlay and "ScreenDemonstration" or "ScreenHowToPlay"
end

-- cutting ScreenHighScores out of the equation for now to pretend it isn't a problem
local useHighScoreScreen = false
local useScreenNoise = false
Branch.NoiseTrigger = function()
	local hour = Hour()
	return (useScreenNoise and hour > 3 and hour < 6) and "ScreenNoise" or (useHighScoreScreen and "ScreenHighScores" or "ScreenInit")
end
